# Expert models for filtering and visualising 

This folder provides code for using expert models to automatically categorise the content of images.

## Filtering
Notably, we're interested in automatically highlighting images that contain humans or NSFW content.
For this we first use face detection and object detection algorithms:

The models in directory `face`, which come from [RetinaFace Pytorch](https://github.com/biubug6/Pytorch_Retinaface/) can detect faces automatically 
and in `person`, we have code that uses models from [detectron2](https://github.com/facebookresearch/detectron2/) to detect humans and human parts. 

Furthermore, we use the [NSFW detector](https://github.com/GantMan/nsfw_model) to look for potentially NSFW content.

## Content
For checking what kind of categories in terms of ImageNet categories might be present, you can use the code contained in the `IN21k` folder, which come from the [Pytorch Image Models library](https://github.com/rwightman/pytorch-image-models/) and originally from [BiT](https://github.com/google-research/big_transfer).

For checking what kind of categories in terms of Places categories might be present, you can use the code contained in `places365`, which comes from the [Places365 repo](https://github.com/CSAILVision/places365/).

## Acknowledgements
We did not train or invent these models so consider citing the creators that we have linked to in this readme.